<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<link type="text/css" rel="stylesheet"  href="<?php echo get_stylesheet_uri(); ?>" media="screen" />
<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/images/brand/favicon.png" />
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<header id="header" role="branding">
		<div id="top-header" role="branding" class="top-header" >
			<div class="container">
				<div class="row">
					<div id="menu" role="navigation" class="col-6 contact-menu float">
						<div class="container">
							<div class="row">
								<div class="col-12">
									<?php wp_nav_menu( array(
										'theme_location'	=> 'contact-menu',
										'container'			=> false,
										'menu_class' 		=> 'contact-menu',
										'depth'  			=> 1,
										'fallback_cb'		=> false ) );
									?>
								</div>
							</div>
						</div>
					</div>
					<div id="menu" role="navigation" class="col-6 site-login desktop">
						<?php wp_nav_menu( array(
							'theme_location'	=> 'login-menu',
							'container'			=> false,
							'menu_class' 		=> 'login-menu',
							'depth'  			=> 1,
							'fallback_cb'		=> false ) );
						?>
					</div>
				</div>
			</div>
		</div>
		<div id="nav-header" role="navigation" class="nav-header">
			<div class="container">
				<div class="row">
					<div id="logo" role="site-branding" class="col-3 site-logo">
						<a href="<?php echo get_option("siteurl"); ?>"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images//brand/logo.png" alt="<?php bloginfo( 'name' ); ?>" width="320" height="70"></a>
					</div>
					<div id="menu" role="navigation" class="col-6 site-login mobile">
						<?php wp_nav_menu( array(
							'theme_location'	=> 'login-menu',
							'container'			=> false,
							'menu_class' 		=> 'login-menu',
							'depth'  			=> 1,
							'fallback_cb'		=> false ) );
						?>
					</div>
					<div id="menu" role="navigation" class="col-10 site-menu desktop">
						<?php wp_nav_menu( array(
							'theme_location'	=> 'games-menu',
							'container'			=> false,
							'menu_class' 		=> 'games-menu',
							'depth'  			=> 1,
							'fallback_cb'		=> false ) );
						?>
					</div>
				</div>
			</div>
		</div>
		
	</header>
	<div class="sticky"></div>